definition module menuhandle


import	osmenu
import	StdMenuDef, receiverhandle, receivertable
from	commondef	import Bound, Finite, Infinite

::	MenuElementState ls ps									// The internal implementation of a menu element

::	MenuHandles ps
	=	{	mMenus			:: [MenuStateHandle ps]			// The menus and their elements of a process
		,	mKeys			:: [Char]						// All shortcut keys of the menus
		,	mOSMenuBar		:: OSMenuBar					// The handle to the toolbox menu bar
		,	mMenuIds		:: [Int]						// Fresh menuIds
		,	mEnabled		:: Bool							// Flag: the whole menusystem is enabled
		,	mNrMenuBound	:: Bound						// The maximum number of menus that are allowed to be opened
		,	mDoASync		:: Bool							// Flag: there are MenuReceivers with non-empty queues
		}
::	MenuStateHandle ps
	=	E..ls: MenuLSHandle	(MenuLSHandle ls ps)			// A menu with local state
::	MenuLSHandle ls ps
	=	{	mlsState		:: ls							// The local state of this menu
		,	mlsHandle		:: MenuHandle ls ps				// The menu implementation
		}
::	MenuHandle ls ps
	=	{	mHandle			:: OSMenu						// The handle to the menu as created by the OS
		,	mMenuId			:: Id							// The menu id
		,	mOSMenuNr		:: OSMenuNr						// The OSMenuNr
		,	mTitle			:: String						// The title of the menu
		,	mSelect			:: Bool							// The MenuSelect==Able (by default True)
// PA---,	mLS				:: Bool							// The menu has local state (True iff works on local state)
		,	mItems			:: [MenuElementHandle ls ps]	// The menu elements of this menu
		}
::	MenuElementHandle ls ps
	=	MenuItemHandle		(MenuItemHandle		 ls ps)
	|	MenuReceiverHandle	(MenuReceiverHandle	 ls ps)
	|	SubMenuHandle		(SubMenuHandle		 ls ps)
	|	RadioMenuHandle		(RadioMenuHandle	 ls ps)
	|	MenuSeparatorHandle	(MenuSeparatorHandle ls ps)
	|	MenuListLSHandle	[MenuElementHandle	 ls ps]
	|	MenuExtendLSHandle	(MenuExtendLSHandle	 ls ps)
	|	MenuChangeLSHandle	(MenuChangeLSHandle	 ls ps)
::	MenuItemHandle ls ps
	=	{	mItemId			:: Maybe Id
		,	mItemKey		:: Maybe Char
		,	mItemTitle		:: Title
		,	mItemSelect		:: Bool
		,	mItemMark		:: Bool
// PA---,	mItemLS			:: Bool
		,	mItemAtts		:: [MenuAttribute *(ls,ps)]
		,	mOSMenuItem		:: OSMenuItem
		}
::	MenuReceiverHandle ls ps
// PA---=	{	mReceiverLS		:: Bool
	=	{	mReceiverHandle	:: ReceiverHandle ls ps
		,	mReceiverAtts	:: [MenuAttribute *(ls,ps)]
		}
::	SubMenuHandle ls ps
	=	{	mSubHandle		:: OSMenu
		,	mSubMenuId		:: Maybe Id
		,	mSubOSMenuNr	:: OSSubMenuNr
		,	mSubItems		:: [MenuElementHandle ls ps]
		,	mSubTitle		:: Title
		,	mSubSelect		:: Bool
// PA---,	mSubLS			:: Bool
		,	mSubAtts		:: [MenuAttribute *(ls,ps)]
		}
::	RadioMenuHandle ls ps
	=	{	mRadioId		:: Maybe Id
		,	mRadioIndex		:: Int								// If mRadioItems==[] 0, otherwise 1..#mRadioItems
		,	mRadioItems		:: [MenuElementHandle ls ps]
		,	mRadioSelect	:: Bool
// PA---,	mRadioLS		:: Bool
		,	mRadioAtts		:: [MenuAttribute *(ls,ps)]
		}
::	MenuSeparatorHandle ls ps
	=	{	mSepId			:: Maybe Id
// PA---,	mSepLS			:: Bool
		,	mOSMenuSeparator:: OSMenuSeparator
		}
::	MenuExtendLSHandle	ls ps
	=	E..ls1:
		{	mExtendLS		:: ls1
		,	mExtendItems	:: [MenuElementHandle *(ls1,ls) ps]
		}
::	MenuChangeLSHandle	ls ps
	=	E..ls1:
		{	mChangeLS		:: ls1
		,	mChangeItems	:: [MenuElementHandle ls1 ps]
		}

//	Conversion functions from MenuElementState to MenuElementHandle, and vice versa:
MenuElementHandleToMenuElementState	:: !(MenuElementHandle .ls .ps) -> MenuElementState  .ls .ps
MenuElementStateToMenuElementHandle	:: !(MenuElementState  .ls .ps) -> MenuElementHandle .ls .ps


menuIdsAreConsistent :: !SystemId !Id ![MenuElementHandle .ls .ps] !ReceiverTable
							-> (!Bool,![MenuElementHandle .ls .ps],!ReceiverTable)
/*	menuIdsAreConsistent checks whether the MenuElementHandles contain R(2)Ids that have already been
	associated with open receivers and if there are no duplicate Ids. 
	The ReceiverTable is not changed if there are duplicate R(2)Ids; otherwise all R(2)Ids have been bound.
*/
//noDuplicateMenuReceiverIds :: !SystemId !Id ![MenuElementState .ls .ps] !ReceiverTable
//								  -> (!Bool,![MenuElementState .ls .ps],!ReceiverTable)
/*	noDuplicateMenuReceiverIds binds all new receiver identification to the ReceiverTable while no duplicate is found.
	The Boolean result is True iff no duplicates were found.
*/

//	Convert a RadioMenuItem to the MenuItemHandle alternative of MenuElementHandle:
RadioMenuItemToMenuElementHandle :: !(MenuRadioItem *(.ls,.ps)) -> MenuElementHandle .ls .ps
